<?php
/*--------------------------------------------------------------------------------------------------
    OnGetSellingUnitQuantityEvent.php 2020-02-13
    Gambio GmbH
    http://www.gambio.de
    Copyright (c) 2020 Gambio GmbH
    Released under the GNU General Public License (Version 2)
    [http://www.gnu.org/licenses/gpl-2.0.html]
    --------------------------------------------------------------------------------------------------
 */

namespace Gambio\Shop\SellingUnit\Database\Unit\Events;

use Gambio\Shop\SellingUnit\Database\Unit\Events\Interfaces\OnGetSellingUnitAvailableQuantityEventInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\AvailableQuantity;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\Interfaces\QuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\ModifierQuantityInterface;
use Gambio\Shop\SellingUnit\Unit\ValueObjects\SellingUnitId;
use ProductDataInterface;

class OnGetSellingUnitAvailableQuantityEvent implements OnGetSellingUnitAvailableQuantityEventInterface
{

    /**
     * @var ?AvailableQuantity
     */
    protected $quantity;
    /**
     * @var bool
     */
    protected $isPropagationStopped = false;
    /**
     * @var SellingUnitId
     */
    protected $id;
    /**
     * @var ProductDataInterface
     */
    protected $product;

    /**
     * OnGetSellingUnitAvailableQuantityEvent constructor.
     * @param SellingUnitId $id
     * @param ProductDataInterface $product
     */
    public function __construct(SellingUnitId $id, ProductDataInterface $product)
    {
        $this->id = $id;
        $this->product = $product;
        $this->quantity = new AvailableQuantity();
    }

    /**
     * @inheritDoc
     */
    public function id(): SellingUnitId
    {
        return $this->id;
    }

    /**
     * @inheritDoc
     */
    public function isPropagationStopped(): bool
    {
        return $this->isPropagationStopped;
    }

    /**
     * @return ProductDataInterface
     */
    public function product(): ProductDataInterface
    {
        return $this->product;
    }

    /**
     * @inheritDoc
     */
    public function quantity(): ?AvailableQuantity
    {
        return $this->quantity;
    }

    /**
     * @inheritDoc
     */
    public function addQuantity(ModifierQuantityInterface $quantity): void
    {
        $this->quantity->addQuantity($quantity);
    }

    public function stopPropagation(): void
    {
        $this->isPropagationStopped = true;
    }
}